/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc.pipeline;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import icyllis.modernui.graphics.textmc.pipeline.TextRenderEffect;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.vector.Matrix4f;

public abstract class GlyphRender {
    public static final int USE_INPUT_COLOR = -1;
    public static final int COLOR_NO_CHANGE = -2;
    public final byte effect;
    public int color = -2;
    public int stringIndex;
    public float offsetX;

    public GlyphRender(byte effect, int stringIndex, float offsetX) {
        this.effect = effect;
        this.stringIndex = stringIndex;
        this.offsetX = offsetX;
    }

    public abstract void drawGlyph(@Nonnull BufferBuilder var1, @Nonnull String var2, float var3, float var4, int var5, int var6, int var7, int var8);

    public abstract void drawGlyph(Matrix4f var1, @Nonnull IRenderTypeBuffer var2, @Nonnull CharSequence var3, float var4, float var5, int var6, int var7, int var8, int var9, boolean var10, int var11);

    public final void drawEffect(@Nonnull IVertexBuilder builder, float x, float y, int r, int g2, int b, int a) {
        if (this.effect != 0) {
            x += this.offsetX;
            if (this.effect == 1) {
                TextRenderEffect.Underline.drawEffect(builder, x, x + this.getAdvance(), y, r, g2, b, a);
            } else if (this.effect == 2) {
                TextRenderEffect.Strikethrough.drawEffect(builder, x, x + this.getAdvance(), y, r, g2, b, a);
            } else if (this.effect == 3) {
                TextRenderEffect.UnderlineStrikethrough.drawEffect(builder, x, x + this.getAdvance(), y, r, g2, b, a);
            }
        }
    }

    public final void drawEffect(Matrix4f matrix, @Nonnull IVertexBuilder builder, float x, float y, int r, int g2, int b, int a, int light) {
        if (this.effect != 0) {
            x += this.offsetX;
            if (this.effect == 1) {
                TextRenderEffect.Underline.drawEffect(matrix, builder, x, x + this.getAdvance(), y, r, g2, b, a, light);
            } else if (this.effect == 2) {
                TextRenderEffect.Strikethrough.drawEffect(matrix, builder, x, x + this.getAdvance(), y, r, g2, b, a, light);
            } else if (this.effect == 3) {
                TextRenderEffect.UnderlineStrikethrough.drawEffect(matrix, builder, x, x + this.getAdvance(), y, r, g2, b, a, light);
            }
        }
    }

    public abstract float getAdvance();
}

